/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBGlobalShortcodeCounterCircle = Object.create(STBModule.prototype);

STBGlobalShortcodeCounterCircle.name = "GlobalShortcodeCounterCircle";
STBGlobalShortcodeCounterCircle.cnt = 1;
STBGlobalShortcodeCounterCircle.initPlugin = function () {

	var counters = $(".countercircle:not(.__done)");

	if (counters.length > 0) {
		counters.each(function() {

			var counter		 = $(this),
				width		 = counter.width(),
				lineWidth	 = parseInt(STBUtils.attrDefaultValue(counter.attr("data-thick") , "14")),
				lineCap		 = STBUtils.attrDefaultValue(counter.attr("data-linecap") , "round"),
				value		 = Math.min(100 , parseFloat(counter.attr("data-value") / 100)),
				colors		 = STBUtils.attrDefaultValue(counter.attr("data-color") , "#2c7ee3").split(","),
				holder_color = STBUtils.attrDefaultValue(counter.attr("data-holder") , "#eee"),
				showPerc	 = STBUtils.attrDefaultValue(counter.attr("data-perc") , "true"),
				perc		 = counter.find(".countercircle-perc"),
				delay		 = STBUtils.attrDefaultValue(counter.attr("data-delay") , 0);



			var canvas = $("<canvas/>");
				canvas.attr("width" , width).attr("height" , width);
		
			counter.append(canvas);

			if (STBGlobalPreloader.isVisible())	{
				canvas.data("inview-force", true);
			}

			canvas.on('inview', function (event, isInView) {
			
				if (isInView) {
					if (!STBGlobalPreloader.isVisible())	{


						setTimeout(function() {
							var ciclerProgress = new CircleProgressBar(
								canvas[0], 
								{
									colors			: colors,
									x				: 0,
									y				: 0,
									trackLineColor	: holder_color,
									lineWidth		: lineWidth,
									lineCap			: lineCap,
									radius			: parseInt((width - lineWidth * 2) / 2 )
								}
							);
							ciclerProgress.setValue(value);


							if (perc.length > 0) {
								//draw the value when complete
								canvas[0].addEventListener('circleProgressBar.afterDraw', function (e) {
									var val = (e.detail.self.getValue() * 100).toFixed(0) + '%';
									perc.html(val);
								}, false);

								//draw progress values
								canvas[0].addEventListener('circleProgressBar.afterFrameDraw', function (e) {
									var val = (e.detail.self.getValue() * e.detail.progress * 100).toFixed(0) + '%';
									perc.html(val);
								}, false);
							}
						} , delay);

						canvas.off("inview");
					} 
				}
			});

			counter.addClass("__done");
		});
	}
}

STBGlobalShortcodeCounterCircle.onResize = function() {

	if (site.newWidth == site.prevWidth) {
		return false;
	}

	//consoleLog(site.newWidth + ":" + site.prevWidth);


	var counters = jQuery(".countercircle");

	if (counters.length > 0){ 
		counters.each(function() {
			var el = jQuery(this);
			el.removeClass("__done");
			el.find("canvas").remove();
		});

		STBGlobalShortcodeCounterCircle.initPlugin();
	}
}


STBGlobalShortcodeCounterCircle.runOnReady = function() {
	STBGlobalShortcodeCounterCircle.initPlugin();
}


STBGlobalShortcodeCounterCircle.runOnContentUpdate = function() {
	STBGlobalShortcodeCounterCircle.initPlugin();
}

STBGlobalShortcodeCounterCircle.runOnResize = function() {
	STBGlobalShortcodeCounterCircle.onResize();
}

site.registerModule(STBGlobalShortcodeCounterCircle);